import * as http from './http';

export function fetchAllProjects(params) {
  return http.sendGet('/api/v2/projects', { _usePagination: true, ...params });
}

export function fetchProject(projectId) {
  return http.sendGet(`/api/v2/projects/${projectId}`);
}

export function fetchProjectPermissions(projectId) {
  return http.sendGet(`/api/internal/projects/${projectId}/permissions`);
}

export function fetchProjectWithPermissions(projectId) {
  return fetchProject(projectId)
    .then((project) => fetchProjectPermissions(projectId)
      .then((permissions) => ({ project, permissions })));
}

export function createProject(project) {
  return http.sendPost('/api/v2/projects', project);
}

export function updateProject(project) {
  return http.sendPut(`/api/v2/projects/${project.id}`, project);
}

export function saveProjectWithPermissions(project, isNew) {
  const promise = isNew
    ? createProject(project)
    : updateProject(project);

  return promise
    .then((prj) => fetchProjectPermissions(project.id)
      .then((permissions) => ({
        project: prj,
        permissions,
      })));
}

export function deleteProject(projectId) {
  return http.sendDelete(`/api/v2/projects/${projectId}`);
}
