import * as http from './http';

export function fetchSensors(projectId, urlParams, useNewFormat) {
  return http.sendGet(`/api/v2/projects/${projectId}/sensors`, { ...urlParams, useNewFormat });
}

export function fetchLabels(projectId, urlParams) {
  let path;

  if (urlParams.names === 'cluster,service') {
    path = `/api/internal/projects/${projectId}/shardLabels`;
  } else {
    path = `/api/v2/projects/${projectId}/sensors/labels`;
  }

  return http.sendGet(path, urlParams);
}

export function fetchClusterServices(projectId, urlParams) {
  return http.sendGet(`/api/internal/projects/${projectId}/shardLabels`, urlParams);
}

export function fetchSensorNamesInNewFormat(projectId, urlParams) {
  return http.sendGet(`/api/v2/projects/${projectId}/sensors/sensorNames`, { ...urlParams, useNewFormat: true });
}

export function fetchLabelValuesInNewFormat(projectId, urlParams) {
  return http.sendGet(`/api/v2/projects/${projectId}/sensors/labels`, { ...urlParams, useNewFormat: true });
}

export function fetchLabelNames(projectId, urlParams) {
  return http.sendGet(`/api/v2/projects/${projectId}/sensors/names`, urlParams);
}
