import * as http from './http';

export function fetchServiceDashboards(urlParams) {
  return http.sendGet('/api/internal/serviceDashboards', urlParams);
}

export function fetchServiceDashboard(id) {
  return http.sendGet(`/api/internal/serviceDashboards/${id}`);
}

export function createServiceDashboard(serviceDashboard) {
  return http.sendPost('/api/internal/serviceDashboards', serviceDashboard);
}

export function updateServiceDashboard(serviceDashboard) {
  return http.sendPut(`/api/internal/serviceDashboards/${serviceDashboard.serviceDashboardId}`, serviceDashboard);
}

export function validateServiceDashboard(serviceDashboard) {
  return http.sendPost('/api/internal/serviceDashboards/validate', serviceDashboard);
}

export function validateServiceDashboardSync(serviceDashboardId, dashboardId) {
  return http.sendPost(`/api/internal/serviceDashboards/${serviceDashboardId}/sync/validate?dashboardId=${encodeURIComponent(dashboardId)}`, null);
}

export function syncServiceDashboard(serviceDashboardId, dashboardId, link) {
  return http.sendPost(`/api/internal/serviceDashboards/${serviceDashboardId}/sync?dashboardId=${encodeURIComponent(dashboardId)}&sourceDashboardLink=${encodeURIComponent(link)}`, null);
}

export function deleteServiceDashboard(id) {
  return http.sendDelete(`/api/internal/serviceDashboards/${id}`);
}
