import * as http from './http';

export function fetchServiceProviders(urlParams) {
  return http.sendGet('/api/internal/serviceProviders', urlParams);
}

export function fetchServiceProvider(id) {
  return http.sendGet(`/api/internal/serviceProviders/${id}`);
}

export function createServiceProvider(serviceProvider) {
  return http.sendPost('/api/internal/serviceProviders', serviceProvider);
}

export function updateServiceProvider(serviceProvider) {
  return http.sendPut(`/api/internal/serviceProviders/${serviceProvider.serviceProviderId}`, serviceProvider);
}

export function deleteServiceProvider(id) {
  return http.sendDelete(`/api/internal/serviceProviders/${id}`);
}
