import * as http from './http';

export function fetchGlobalServices(urlParams) {
  return http.sendGet('/api/internal/services', urlParams);
}

export function fetchProjectServices(projectId, urlParams) {
  return http.sendGet(`/api/v2/projects/${projectId}/services`, urlParams);
}

export function fetchService(projectId, serviceId) {
  return http.sendGet(`/api/v2/projects/${projectId}/services/${serviceId}`);
}

export function createService(projectId, service) {
  return http.sendPost(`/api/v2/projects/${projectId}/services`, service);
}

export function updateService(projectId, service) {
  return http.sendPut(`/api/v2/projects/${projectId}/services/${service.id}`, service);
}

export function deleteService(projectId, serviceId) {
  return http.sendDelete(`/api/v2/projects/${projectId}/services/${serviceId}`);
}

export function fetchServiceClusters(projectId, serviceId) {
  return http.sendGet(`/api/v2/projects/${projectId}/services/${serviceId}/clusters`);
}
