import * as http from './http';

export function fetchGlobalShards(urlParams) {
  return http.sendGet('/api/internal/shards', urlParams);
}

export function fetchProjectShards(projectId, urlParams) {
  return http.sendGet(`/api/v2/projects/${projectId}/shards`, urlParams);
}

export function fetchShard(projectId, shardId) {
  return http.sendGet(`/api/v2/projects/${projectId}/shards/${shardId}`);
}

export function createShard(projectId, shard) {
  return http.sendPost(`/api/v2/projects/${projectId}/shards`, shard);
}

export function updateShard(projectId, shard) {
  return http.sendPut(`/api/v2/projects/${projectId}/shards/${shard.id}`, shard);
}

export function deleteShard(projectId, shardId) {
  return http.sendDelete(`/api/v2/projects/${projectId}/shards/${shardId}`);
}

export function fetchShardTargetsStatus(projectId, shardId, urlParams) {
  return http.sendGet(`/api/v2/projects/${projectId}/shards/${shardId}/targets`, urlParams);
}

export function fetchServiceProviderTargetsStatus(serviceProviderId, urlParams) {
  return http.sendGet(`/api/internal/serviceProviders/${serviceProviderId}/targets`, urlParams);
}
