import 'whatwg-fetch';

import AuthState from './AuthState';

const PASSPORT_URL = 'https://passport.yandex-team.ru/auth';

const Auth = {
  state: new AuthState('unknown', []),

  setState(state) {
    this.state = state;
  },

  hasRole(role) {
    return this.state.hasRole(role);
  },

  redirectToPassport(redirectBack) {
    let path = PASSPORT_URL;
    if (redirectBack) {
      const url = encodeURIComponent(window.location.href.replace(/#.*/, ''));
      path += `?retpath=${url}`;
    }
    window.location.replace(path);
  },
};

export default Auth;
