import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import Datalist from '../Datalist';
import fetchAbcServiceDuties from './abcDutyRequest';
import debounce from '../../utils/debounce';

import './style.css';

class AbcDutySuggest extends PureComponent {
  _loadDataDebounced = debounce((abcService, value) => {
    fetchAbcServiceDuties(abcService)
      .then((resp) => {
        const list = resp.filter((item) => item.slug.startsWith(value) || value === '').map((item) => ({
          slug: item.slug,
          name: item.name,
        }));

        this.setState({ abcServiceDutiesList: list });
      })
      .catch(() => {});
  }, 100);

  constructor(props) {
    super(props);

    this.state = { value: props.value, abcServiceDutiesList: [] };
  }

  componentDidUpdate(prevProps) {
    if (this.props.value !== prevProps.value) {
      this.setState({ value: this.props.value, abcServiceDutiesList: [] });
    }
  }

  handleChange = (event) => {
    const { value } = event.target;
    this.setState({ value });
    this.props.onChange(value);
    this._loadDataDebounced(this.props.abcService, event.target.value);
  };

  render() {
    const { value } = this.state;

    const mappedDatalist = this.state.abcServiceDutiesList.map((item) => ({
      value: item.slug,
      content: (
        <div className="abc-suggest__item">
          <div className="abc-suggest__slug">
            {`${item.slug}`}
          </div>
          <div className="abc-suggest__title">
            {item.name}
          </div>
        </div>
      ),
    }));

    return (
      <Datalist
        datalist={mappedDatalist}
        value={value}
        placeholder="Enter ABC duty slug..."
        onChange={this.handleChange}
      />
    );
  }
}

AbcDutySuggest.propTypes = {
  value: PropTypes.string,
  abcService: PropTypes.string,
  onChange: PropTypes.func,
};

AbcDutySuggest.defaultProps = {
  value: '',
  abcService: '',
  onChange: () => {},
};

export default AbcDutySuggest;
