import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import Datalist from '../Datalist';
import fetchAbcServices from './abcRequest';
import debounce from '../../utils/debounce';

import './style.css';

class AbcSuggest extends PureComponent {
  _loadDataDebounced = debounce((value) => {
    fetchAbcServices(value)
      .then((resp) => {
        const list = resp.map((item) => ({
          slug: item.slug.replace('svc_', ''),
          title: item.title,
        }));

        this.setState({ abcServicesList: list });
      })
      .catch(() => {});
  }, 100);

  constructor(props) {
    super(props);

    this.state = { value: props.value, abcServicesList: [] };
  }

  componentDidUpdate(prevProps) {
    if (this.props.value !== prevProps.value) {
      this.setState({ value: this.props.value, abcServicesList: [] });
    }
  }

  handleChange = (event) => {
    const { value } = event.target;
    this.setState({ value });
    this.props.onChange(value);
    this._loadDataDebounced(event.target.value);
  };

  render() {
    const { value } = this.state;

    const mappedDatalist = this.state.abcServicesList.map((item) => ({
      value: item.slug,
      content: (
        <div className="abc-suggest__item">
          <div className="abc-suggest__slug">
            {`${item.slug}`}
          </div>
          <div className="abc-suggest__title">
            {item.title}
          </div>
        </div>
      ),
    }));

    return (
      <Datalist
        datalist={mappedDatalist}
        value={value}
        placeholder="Enter ABC service name or slug..."
        onChange={this.handleChange}
      />
    );
  }
}

AbcSuggest.propTypes = {
  value: PropTypes.string,
  onChange: PropTypes.func,
};

AbcSuggest.defaultProps = {
  value: '',
  onChange: () => {},
};

export default AbcSuggest;
