import { formatSearch } from '../../utils/url';

function fetchAbcServiceDuties(abcService) {
  if (!abcService) {
    return Promise.resolve([]);
  }

  const params = {
    service__slug: abcService,
  };

  const search = formatSearch(params);

  const url = `https://abc-back.yandex-team.ru/api/v4/duty/schedules/?fields=slug,id,name&${search}`;

  return fetch(url, { credentials: 'include' })
    .then((result) => {
      if (result.ok) {
        return result.json().then((response) => response.results);
      }

      return Promise.reject(new Error('abc result is not ok'));
    });
}

export default fetchAbcServiceDuties;
