import { formatSearch } from '../../utils/url';

function fetchAbcServices(text) {
  if (!text) {
    return Promise.resolve([]);
  }

  const params = {
    version: 2,
    layers: 'groups',
    'groups.query': 's_type:service',
    'groups.per_page': 10,
  };

  if (text) {
    params.text = text;
  }

  const search = formatSearch(params);

  const url = `//search.yandex-team.ru/suggest/?${search}`;

  return fetch(url, { credentials: 'include' })
    .then((result) => {
      if (result.ok) {
        return result.json().then((response) => response.groups.result);
      }

      return Promise.reject(new Error('abc result is not ok'));
    });
}

export default fetchAbcServices;
