import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { CSSTransition, TransitionGroup } from 'react-transition-group';

import { removeAlert } from '../../store/reducers/toaster';

import './style.css';

const Alert = ({ type, onClose, children }) => (
  <div className={`alert alert-${type} alert-dismissible`} role="alert">
    <button type="button" className="close" onClick={onClose}>&times;</button>
    {children}
  </div>
);

Alert.propTypes = {
  type: PropTypes.string.isRequired,
  onClose: PropTypes.func.isRequired,
  children: PropTypes.oneOfType([
    PropTypes.string,
    PropTypes.element,
  ]).isRequired,
};

const timeout = { enter: 500, exit: 300 };

const AlertsList = ({ alerts, dispatch }) => (
  <TransitionGroup className="alerts-list">
    {alerts.map((a) => (
      <CSSTransition key={a.id} classNames="alert" timeout={timeout}>
        <Alert type={a.type} onClose={() => dispatch(removeAlert(a.id))}>
          {a.message}
        </Alert>
      </CSSTransition>
    ))}
  </TransitionGroup>
);

AlertsList.propTypes = {
  alerts: PropTypes.array.isRequired,
  dispatch: PropTypes.func.isRequired,
};

function mapStateToProps(state) {
  return { alerts: state.alerts };
}

export default connect(mapStateToProps)(AlertsList);
