import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

const isModifiedEvent = (event) => !!(event.metaKey
  || event.altKey
  || event.ctrlKey
  || event.shiftKey);

class BackLink extends PureComponent {
  handleClick = (event) => {
    if (!event.defaultPrevented && event.button === 0 && !isModifiedEvent(event)) {
      event.preventDefault();

      const { history } = this.context.router;
      history.goBack();
    }
  };

  render() {
    return <a {...this.props} onClick={this.handleClick} href="#">{this.props.children}</a>;
  }
}

BackLink.propTypes = {
  children: PropTypes.oneOfType([PropTypes.string, PropTypes.element]).isRequired,
};

BackLink.contextTypes = {
  router: PropTypes.shape({
    history: PropTypes.shape({
      goBack: PropTypes.func.isRequired,
    }).isRequired,
  }).isRequired,
};

export default BackLink;
