import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

class ButtonGroup extends PureComponent {
  handleButtonClick = (event) => {
    event.preventDefault();

    const { name } = event.target;

    let nextValues;

    const nameIndex = this.props.values.indexOf(name);
    if (nameIndex < 0) {
      nextValues = [...this.props.values, name];
    } else {
      nextValues = [...this.props.values];
      nextValues.splice(nameIndex, 1);
    }

    this.props.onChange(nextValues);
  };

  render() {
    const { choices, values } = this.props;
    let { labels } = this.props;

    if (labels.length === 0) {
      labels = choices;
    }

    const btnClass = (choice) => {
      if (values.indexOf(choice) >= 0) {
        return 'btn btn-default active';
      }
      return 'btn btn-default';
    };

    const buttons = choices.map((c, i) => (
      <button
        key={c} name={c} type="button" className={btnClass(c)}
        onClick={this.handleButtonClick}
      >
        {labels[i]}
      </button>
    ));

    return (
      <div className="btn-group" style={this.props.style}>
        {buttons}
      </div>
    );
  }
}

ButtonGroup.propTypes = {
  choices: PropTypes.arrayOf(PropTypes.string).isRequired,
  labels: PropTypes.arrayOf(PropTypes.string),
  values: PropTypes.arrayOf(PropTypes.string),
  style: PropTypes.object,
  onChange: PropTypes.func.isRequired,
};

ButtonGroup.defaultProps = {
  labels: [],
  values: [],
  style: {},
};

export default ButtonGroup;
