/* eslint-disable
jsx-a11y/interactive-supports-focus,
jsx-a11y/click-events-have-key-events,
jsx-a11y/control-has-associated-label
*/
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import Overlay from 'react-bootstrap/es/Overlay';
import Tooltip from 'react-bootstrap/es/Tooltip';

import { copyContent } from '../../utils/clipboard';

import './style.css';

class CopyButton extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { showTooltip: false };
  }

  onClick = () => {
    copyContent(this.props.value);
    this.setState({ showTooltip: true }, () => {
      window.setTimeout(() => {
        this.setState({ showTooltip: false });
      }, 1000);
    });
  };

  render() {
    const tooltip = (
      <Tooltip id="copy-button-tooltip">
        Copied!
      </Tooltip>
    );

    const button = (
      <i
        role="button"
        className="copy-btn solomon-link copy-icon"
        onClick={this.onClick}
        ref={(el) => {
          this._button = el;
        }}
      />
    );

    return (
      <>
        {button}
        <Overlay
          target={this._button}
          container={this.props.container}
          show={this.state.showTooltip}
          placement="top"
        >
          {tooltip}
        </Overlay>
      </>
    );
  }
}

CopyButton.propTypes = {
  value: PropTypes.string.isRequired,
  container: PropTypes.element,
};

CopyButton.defaultProps = {
  container: null,
};

export default CopyButton;
