import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import LabeledValue from '../LabeledValue';

class DashboardReadonlyPanel extends PureComponent {
  onEditClick = () => {
    this.props.onEdit(this.props.index);
  };

  onDeleteClick = () => {
    this.props.onDelete(this.props.index);
  };

  render() {
    const { index, panel, readOnly } = this.props;

    const panelType = panel.type || 'IFRAME';

    return (
      <div className="panel panel-default">
        <div className="panel-heading">
          <div className="clearfix">
            <div className="pull-left">
              <h3 className="panel-title ellipsis-overflow">
                Panel #
                {index + 1}
              </h3>
            </div>
            {!readOnly && (
            <div className="pull-right">
              <button type="button" className="btn btn-default" onClick={this.onEditClick}>
                <i className="glyphicon glyphicon-pencil" />
              </button>
              &nbsp;
              <button type="button" className="btn btn-default" onClick={this.onDeleteClick}>
                <i className="glyphicon glyphicon-trash" />
              </button>
            </div>
            )}
          </div>
        </div>
        <div className="panel-body">
          <div>
            {!panel.title ? null : (
              <LabeledValue label="Title" value={panel.title} labelWidth={2} />
            )}
            {!panel.subtitle ? null : (
              <LabeledValue label="Subtitle" value={panel.subtitle} labelWidth={2} />
            )}
            {panelType === 'IFRAME' && (
              <LabeledValue label="Url" value={panel.url} labelWidth={2} />
            )}
            {panelType === 'MARKDOWN' && (
              <LabeledValue label="Markdown" value={panel.markdown} labelWidth={2} />
            )}
            {!panel.rowspan ? null : <LabeledValue label="Row span" value={panel.rowspan} labelWidth={2} />}
            {!panel.colspan ? null : <LabeledValue label="Col span" value={panel.colspan} labelWidth={2} />}
          </div>
        </div>
      </div>
    );
  }
}

DashboardReadonlyPanel.propTypes = {
  index: PropTypes.number.isRequired,
  panel: PropTypes.object.isRequired,
  onEdit: PropTypes.func.isRequired,
  onDelete: PropTypes.func.isRequired,
  readOnly: PropTypes.bool.isRequired,
};

export default DashboardReadonlyPanel;
