/* eslint-disable react/no-array-index-key */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import DashboardEditablePanel from './DashboardEditablePanel';
import DashboardReadonlyPanel from './DashboardReadonlyPanel';
import { EI_NEW } from './constants';

class DashboardRow extends PureComponent {
  onAddPanelClick = () => {
    this.props.onAddPanel(this.props.rowIndex);
  };

  onEditPanelClick = (panelIndex) => {
    this.props.onEditPanel(this.props.rowIndex, panelIndex);
  };

  onDeletePanelClick = (panelIndex) => {
    this.props.onDeletePanel(this.props.rowIndex, panelIndex);
  };

  onSubmitPanelClick = (panelIndex, panel) => {
    this.props.onSubmitPanel(this.props.rowIndex, panelIndex, panel);
  };

  onDiscardPanelClick =() => {
    this.props.onDiscardPanel(this.props.rowIndex);
  };

  onDeleteRowClick = () => {
    this.props.onDeleteRow(this.props.rowIndex);
  };

  render() {
    const { panelEditIndex, row, readOnly } = this.props;
    const panels = row.panels || [];

    return (
      <div className="panel panel-default dashboard-row">
        <div className="panel-heading">
          <div className="clearfix">
            <div className="pull-left">
              <h3 className="panel-title">
                Row #
                {this.props.rowIndex + 1}
              </h3>
            </div>
            {!this.props.readOnly && (
            <div className="pull-right">
              <button type="button" className="btn btn-default" onClick={this.onDeleteRowClick}>
                <i className="glyphicon glyphicon-trash" />
              </button>
            </div>
            )}
          </div>
        </div>
        <div className="panel-body">
          {panels.map((panel, panelIndex) => {
            if (panelIndex === panelEditIndex) {
              return (
                <DashboardEditablePanel
                  key={panelIndex}
                  index={panelIndex}
                  panel={panel}
                  onSubmit={this.onSubmitPanelClick}
                  onDiscard={this.onDiscardPanelClick}
                />
              );
            }
            return (
              <DashboardReadonlyPanel
                key={panelIndex}
                index={panelIndex}
                panel={panel}
                onEdit={this.onEditPanelClick}
                onDelete={this.onDeletePanelClick}
                readOnly={readOnly}
              />
            );
          })}
          {panelEditIndex === EI_NEW && (
            <DashboardEditablePanel
              index={panelEditIndex}
              onSubmit={this.onSubmitPanelClick}
              onDiscard={this.onDiscardPanelClick}
            />
          )}
          {!readOnly && (
          <div>
            <button type="button" className="btn btn-default" onClick={this.onAddPanelClick}>
              <i className="glyphicon glyphicon-plus" />
              {' '}
              Add panel
            </button>
          </div>
          )}
        </div>
      </div>
    );
  }
}

DashboardRow.propTypes = {
  rowIndex: PropTypes.number.isRequired,
  panelEditIndex: PropTypes.number.isRequired,
  row: PropTypes.object.isRequired,
  onAddPanel: PropTypes.func.isRequired,
  onEditPanel: PropTypes.func.isRequired,
  onDeletePanel: PropTypes.func.isRequired,
  onSubmitPanel: PropTypes.func.isRequired,
  onDiscardPanel: PropTypes.func.isRequired,
  onDeleteRow: PropTypes.func.isRequired,
  readOnly: PropTypes.bool.isRequired,
};

export default DashboardRow;
