/* eslint-disable react/no-array-index-key */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import DashboardRow from './DashboardRow';
import * as EDIT_INDEXES from './constants';

class DashboardRowsEditor extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      rowEditIndex: EDIT_INDEXES.EI_NONE,
      panelEditIndex: EDIT_INDEXES.EI_NONE,
    };
  }

  onAddRow = () => {
    const newRows = [...this.props.rows];
    newRows.push({ panels: [] });
    this.props.onChange(newRows);
  };

  onAddPanel = (rowIndex) => {
    this.setState({ rowEditIndex: rowIndex, panelEditIndex: EDIT_INDEXES.EI_NEW });
  };

  onDeleteRow = (rowIndex) => {
    const newRows = [...this.props.rows];
    newRows.splice(rowIndex, 1);
    this.props.onChange(newRows);
    this.onDiscardPanel();
  };

  onEditPanel = (rowIndex, panelIndex) => {
    this.setState({ rowEditIndex: rowIndex, panelEditIndex: panelIndex });
  };

  onDeletePanel = (rowIndex, panelIndex) => {
    const newRows = [...this.props.rows];
    const newRow = { ...newRows[rowIndex] };
    const newPanels = [...newRow.panels];
    newPanels.splice(panelIndex, 1);
    newRow.panels = newPanels;
    newRows[rowIndex] = newRow;
    this.props.onChange(newRows);
    this.onDiscardPanel();
  };

  onSubmitPanel = (rowIndex, panelIndex, panel) => {
    const newRows = [...this.props.rows];
    const newRow = { ...newRows[rowIndex] };
    const newPanels = [...newRow.panels];
    if (panelIndex < 0) {
      newPanels.push(panel);
    } else {
      newPanels.splice(panelIndex, 1, panel);
    }
    newRow.panels = newPanels;
    newRows[rowIndex] = newRow;
    this.props.onChange(newRows);
    this.onDiscardPanel();
  };

  onDiscardPanel = () => {
    this.setState({ rowEditIndex: EDIT_INDEXES.EI_NONE, panelEditIndex: EDIT_INDEXES.EI_NONE });
  };

  render() {
    const { rows, readOnly } = this.props;
    const { rowEditIndex, panelEditIndex } = this.state;

    return (
      <div>
        <div>
          {rows.map((row, index) => (
            <DashboardRow
              key={index}
              rowIndex={index}
              panelEditIndex={index === rowEditIndex ? panelEditIndex : EDIT_INDEXES.EI_NONE}
              row={row}
              onAddPanel={this.onAddPanel}
              onDeleteRow={this.onDeleteRow}
              onEditPanel={this.onEditPanel}
              onDeletePanel={this.onDeletePanel}
              onDiscardPanel={this.onDiscardPanel}
              onSubmitPanel={this.onSubmitPanel}
              readOnly={readOnly}
            />
          ))}
        </div>
        {!readOnly && (
        <div>
          <button type="button" className="btn btn-default" onClick={this.onAddRow}>
            <i className="glyphicon glyphicon-plus" />
          </button>
        </div>
        )}
      </div>
    );
  }
}

DashboardRowsEditor.propTypes = {
  rows: PropTypes.array,
  onChange: PropTypes.func,
  readOnly: PropTypes.bool,
};

DashboardRowsEditor.defaultProps = {
  rows: [],
  readOnly: false,
  onChange: () => {},
};

export default DashboardRowsEditor;
