import React from 'react';
import PropTypes from 'prop-types';
import LabeledValue from './LabeledValue';
import { MIN_DATE } from './LocalDate';
import UserName from './UserName';
import { formatLocalDate } from '../utils/localDate';

const Row = ({ title, date, login }) => {
  if (!date && !login) {
    return null;
  }

  let value;

  let formattedDate = null;

  if (date) {
    const parsedDate = new Date(date);

    if (parsedDate.getTime() >= MIN_DATE.getTime()) {
      formattedDate = formatLocalDate(parsedDate);
    }
  }

  if (formattedDate && login) {
    value = (
      <span>
        at
        {' '}
        <i>{formattedDate}</i>
        {' '}
        by
        {' '}
        <UserName login={login} />
      </span>
    );
  } else if (formattedDate) {
    value = (
      <span>
        at
        {' '}
        <i>{formattedDate}</i>
      </span>
    );
  } else if (login) {
    value = (
      <span>
        by
        {' '}
        <UserName login={login} />
      </span>
    );
  } else {
    value = '-';
  }

  return (
    <LabeledValue label={title} value={value} />
  );
};

Row.propTypes = {
  title: PropTypes.string.isRequired,
  date: PropTypes.string,
  login: PropTypes.string,
};

Row.defaultProps = {
  date: '',
  login: '',
};

const EntityInfo = ({ entity }) => {
  const {
    createdAt, createdBy, updatedAt, updatedBy,
  } = entity;

  if (createdAt === updatedAt && createdBy === updatedBy) {
    return (<Row title="Created" date={createdAt} login={createdBy} />);
  }

  return (
    <div>
      <Row title="Created" date={createdAt} login={createdBy} />
      <Row title="Updated" date={updatedAt} login={updatedBy} />
    </div>
  );
};

EntityInfo.propTypes = {
  entity: PropTypes.shape({
    createdAt: PropTypes.string,
    updatedAt: PropTypes.string,
    createdBy: PropTypes.string,
    updatedBy: PropTypes.string,
  }),
};

EntityInfo.defaultProps = {
  entity: {
    createdAt: '',
    updatedAt: '',
    createdBy: '',
    updatedBy: '',
  },
};

export default EntityInfo;
