import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import LabeledValue from '../LabeledValue';

class ReadonlyElement extends PureComponent {
  onEditClick = (event) => {
    event.preventDefault();
    this.props.onEdit(this.props.index);
  };

  onDeleteClick = (event) => {
    event.preventDefault();
    this.props.onDelete(this.props.index);
  };

  render() {
    const { value, readOnly } = this.props;
    const type = value.type || 'SELECTORS';

    let areaValue;
    if (value.area === true) {
      areaValue = 'On';
    } else if (value.area === false) {
      areaValue = 'Off';
    } else {
      areaValue = 'Default';
    }

    return (
      <div className="panel panel-default">
        <div className="panel-heading">
          <div className="clearfix">
            <div className="pull-left">
              <h3 className="panel-title ellipsis-overflow">
                Element #
                {this.props.index + 1}
              </h3>
            </div>
            {!readOnly && (
            <div className="pull-right">
              <button type="button" className="btn btn-xs btn-default" onClick={this.onEditClick}>
                <i className="glyphicon glyphicon-pencil" />
              </button>
              &nbsp;
              <button type="button" className="btn btn-xs btn-default" onClick={this.onDeleteClick}>
                <i className="glyphicon glyphicon-trash" />
              </button>
            </div>
            )}
          </div>
        </div>
        <div className="panel-body">
          <div>
            {value.title ? (
              <LabeledValue label="Title" value={value.title} />
            ) : null}
            {type === 'SELECTORS' && (
              <LabeledValue label="Selectors" value={(value.selectors || []).map((x) => `${x.name}=${x.value}`).join(',')} />
            )}
            {type === 'SELECTORS' && value.link && (
              <LabeledValue label="Link" value={value.link} />
            )}
            {type === 'EXPRESSION' && (
              <LabeledValue label="Expression" value={value.expression} />
            )}
            {value.color && <LabeledValue label="Color" value={value.color} />}
            {<LabeledValue label="Area" value={areaValue} />}
            {value.stack && <LabeledValue label="Stack" value={value.stack} />}
            {value.down && <LabeledValue label="Down" value={value.down} />}
            {value.yaxis && <LabeledValue label="Y-axis position" value={value.yaxis} />}
            {value.transform !== 'NONE' && <LabeledValue label="Transform" value={value.transform} />}
          </div>
        </div>
      </div>
    );
  }
}

ReadonlyElement.propTypes = {
  index: PropTypes.number.isRequired,
  value: PropTypes.object.isRequired,
  onEdit: PropTypes.func.isRequired,
  onDelete: PropTypes.func.isRequired,
  readOnly: PropTypes.bool.isRequired,
};

export default ReadonlyElement;
