/* eslint-disable import/no-extraneous-dependencies */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { withRouter } from 'react-router';
import { Link } from 'react-router-dom';
import Navbar from 'react-bootstrap/es/Navbar';
import Nav from 'react-bootstrap/es/Nav';

import { isPreEnv, isTestEnv } from '../../utils/env';
import Auth from '../../auth/Auth';

import HeaderMenu from './HeaderMenu/HeaderMenu';
import ProjectNav from './ProjectNav';
import Userpic from './Userpic/Userpic';
import SolomonInfraBuzzer from './SolomonInfraBuzzer';

import solomonLogo from './logos/logo.svg';
import inverseSolomonLogo from './logos/logo.inverse.svg';

import './style.css';

const PROJECT_NAME_REGEXP = /^\/admin\/projects\/([^/]+)\/?.*/;

class AdminHeader extends PureComponent {
  static computeHeaderStyleClass(isInverseAdminHeader) {
    if (isPreEnv()) {
      return {
        styleClass: 'solomon-navbar-blue',
        inverseLogo: true,
      };
    }

    if (isTestEnv()) {
      return {
        styleClass: 'solomon-navbar-brown',
        inverseLogo: true,
      };
    }

    if (isInverseAdminHeader) {
      return {
        styleClass: 'navbar-inverse',
        inverseLogo: true,
      };
    }

    return {
      styleClass: 'navbar-default',
      inverseLogo: false,
    };
  }

  render() {
    const {
      location, projectName, login, isInverseAdminHeader,
    } = this.props;

    const match = PROJECT_NAME_REGEXP.exec(location.pathname);
    const projectId = match ? match[1] : null;

    const { styleClass, inverseLogo } = AdminHeader.computeHeaderStyleClass(isInverseAdminHeader);

    const logo = inverseLogo ? inverseSolomonLogo : solomonLogo;

    const headerMenu = <HeaderMenu />;

    const logoNav = (
      <Navbar.Header>
        <Link to="/admin" className="navbar-brand solomon-brand">
          <img src={logo} alt="Solomon" />
        </Link>
      </Navbar.Header>
    );

    const projectNav = projectId && projectId !== 'new' && projectName ? (
      <div role="navigation">
        <ul className="nav navbar-nav">
          <li>
            <ProjectNav projectId={projectId} projectName={projectName} link={`/admin/projects/${projectId}`} />
          </li>
        </ul>
      </div>
    ) : null;

    const rightNav = (
      <Nav pullRight>
        <li style={{ margin: '12px 10px 0 10px' }}>
          <SolomonInfraBuzzer />
        </li>
        <li>
          <a className="right-menu-link" href="/docs" rel="noreferrer" target="_blank">
            <span className="glyphicon glyphicon-question-sign" />
          </a>
        </li>
        <Userpic login={login} />
      </Nav>
    );

    return (
      <Navbar className={styleClass} staticTop fixedTop fluid>
        {headerMenu}
        {logoNav}
        {projectNav}
        {rightNav}
      </Navbar>
    );
  }
}

AdminHeader.propTypes = {
  login: PropTypes.string.isRequired,
  projectName: PropTypes.string.isRequired,
  location: PropTypes.object.isRequired,
  isInverseAdminHeader: PropTypes.bool.isRequired,
};

export default withRouter(connect(
  (state) => ({
    login: Auth.state.login(),
    projectName: state.projectData.project.name || '',
    isInverseAdminHeader: state.userSettings.data
      && state.userSettings.data.settings.experimentalInverseAdminHeader === 'true',
  }),
)(AdminHeader));
