import React, { PureComponent } from 'react';
import NavDropdown from 'react-bootstrap/es/NavDropdown';
import Nav from 'react-bootstrap/es/Nav';
import menuData from './infraMenu';
import Item from './Item';

// TODO (rorewillo@): use https://github.yandex-team.ru/data-ui/react-components/tree/master/lib/components/HeaderMenu
class HeaderMenu extends PureComponent {
  static _hamburger() {
    return (
      <svg width="24" height="24" viewBox="0 0 24 24">
        <path fill="currentColor" d="M3,6H21V8H3V6M3,11H21V13H3V11M3,16H21V18H3V16Z" />
      </svg>
    );
  }

  render() {
    return (
      <Nav className="solomon-menu-button" pullLeft>
        <NavDropdown
          title={HeaderMenu._hamburger()}
          id="header-menu-dropdown"
          noCaret
        >
          {menuData.map((item, index) => (
            // eslint-disable-next-line react/no-array-index-key
            <Item key={index} item={item} />
          ))}
        </NavDropdown>
      </Nav>
    );
  }
}

export default HeaderMenu;
