/* eslint-disable react/no-array-index-key */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import MenuItem from 'react-bootstrap/es/MenuItem';
import NavDropdown from 'react-bootstrap/es/NavDropdown';

const ItemProps = PropTypes.shape({
  type: PropTypes.oneOf(['title', 'item', 'separator']).isRequired,
  content: PropTypes.string,
  service: PropTypes.string,
  host: PropTypes.string,
  path: PropTypes.string,
  submenu: PropTypes.array,
});

class Item extends PureComponent {
  static lastId = 0;

  static nextUniqId() {
    Item.lastId += 1;
    return `item-${Item.lastId}`;
  }

  constructor(props) {
    super(props);
    this._id = Item.nextUniqId();
  }

  render() {
    const { item } = this.props;

    if (item.type === 'title') {
      return (
        <MenuItem header>{item.content.toUpperCase()}</MenuItem>
      );
    }

    if (item.type === 'item') {
      if (item.submenu && item.submenu.length > 0) {
        return (
          <NavDropdown id={this._id} className="dropdown-submenu" title={item.content} noCaret>
            {item.submenu.map((subItem, index) => <Item key={index} item={subItem} />)}
          </NavDropdown>
        );
      }

      const url = `https://${item.host}${item.path}`;

      return <MenuItem href={url} target="_blank">{item.content}</MenuItem>;
    }

    if (item.type === 'separator') {
      return <MenuItem divider />;
    }

    return null;
  }
}

Item.propTypes = {
  item: ItemProps.isRequired,
};

export default Item;
