/* eslint-disable import/no-extraneous-dependencies */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { Link } from 'react-router-dom';

import Navbar from 'react-bootstrap/es/Navbar';
import Nav from 'react-bootstrap/es/Nav';

import HeaderMenu from './HeaderMenu/HeaderMenu';
import CogMenu from './CogMenu';
import ProjectMenu from './ProjectMenu/ProjectMenu';
import ProjectNav from './ProjectNav';
import Userpic from './Userpic/Userpic';
import SolomonInfraBuzzer from './SolomonInfraBuzzer';

import { isPreEnv, isTestEnv } from '../../utils/env';
import { parseSearch } from '../../utils/url';

import Auth from '../../auth/Auth';

import solomonLogo from './logos/logo.svg';
import inverseSolomonLogo from './logos/logo.inverse.svg';

import './style.css';

class OldHeader extends PureComponent {
  static computeHeaderStyleClass(isDefaultOldHeader) {
    if (isPreEnv()) {
      return {
        styleClass: 'solomon-navbar-blue',
        inverseLogo: true,
      };
    }

    if (isTestEnv()) {
      return {
        styleClass: 'solomon-navbar-brown',
        inverseLogo: true,
      };
    }

    if (isDefaultOldHeader) {
      return {
        styleClass: 'navbar-default',
        inverseLogo: false,
      };
    }

    return {
      styleClass: 'navbar-inverse',
      inverseLogo: true,
    };
  }

  render() {
    const {
      location, menu, projectName, isDefaultOldHeader,
    } = this.props;

    const login = Auth.state.login();

    const search = location ? location.search : window.location.search;
    const parsedSearch = parseSearch(search);
    const projectId = parsedSearch.get('project') || null;
    const { styleClass, inverseLogo } = OldHeader.computeHeaderStyleClass(isDefaultOldHeader);

    const { menuItems, shardId, shardDcs } = menu;

    const headerMenu = <HeaderMenu />;

    const logo = inverseLogo ? inverseSolomonLogo : solomonLogo;

    const logoNav = (
      <Navbar.Header>
        <Link to={window.location.pathname} className="navbar-brand solomon-brand">
          <img src={logo} alt="Solomon" />
        </Link>
      </Navbar.Header>
    );

    const projectNav = projectId && projectId !== 'new' && projectName ? (
      <div role="navigation">
        <ul className="nav navbar-nav">
          <li>
            <ProjectNav
              projectId={projectId}
              projectName={projectName}
              link={{ pathname: window.location.pathname, search: `?project=${projectId}` }}
            />
          </li>
        </ul>
      </div>
    ) : null;

    const projectMenuNav = <ProjectMenu items={menuItems} />;

    const rightNav = (
      <Nav pullRight>
        <li style={{ margin: '12px 10px 0 10px' }}>
          <SolomonInfraBuzzer />
        </li>
        <li>
          <a className="right-menu-link" href="/docs" rel="noreferrer" target="_blank">
            <span className="glyphicon glyphicon-question-sign" />
          </a>
        </li>
        <CogMenu
          search={search}
          shardId={shardId}
          shardDcs={shardDcs}
        />
        <Userpic login={login} />
      </Nav>
    );

    return (
      <Navbar className={styleClass} staticTop fluid>
        {headerMenu}
        {logoNav}
        {projectNav}
        {projectMenuNav}
        {rightNav}
      </Navbar>
    );
  }
}

OldHeader.propTypes = {
  menu: PropTypes.object,
  projectName: PropTypes.string.isRequired,
  location: PropTypes.object,
  isDefaultOldHeader: PropTypes.bool,
};

OldHeader.defaultProps = {
  menu: {},
  location: null,
  isDefaultOldHeader: false,
};

export default connect(
  (state) => ({
    projectName: state.projectData.project.name || '',
    isDefaultOldHeader: state.userSettings.data
      && state.userSettings.data.settings.experimentalDefaultOldHeader === 'true',
  }),
)(OldHeader);
