/* eslint-disable react/no-array-index-key */

import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import NavDropdown from 'react-bootstrap/es/NavDropdown';
import SecondLevelMenuItem from './SecondLevelMenuItem';
import MenuItem from './MenuItem';

class FirstLevelMenuItem extends PureComponent {
  static lastId = 0;

  constructor(props) {
    super(props);
    FirstLevelMenuItem.lastId += 1;
    this._id = FirstLevelMenuItem.lastId;
  }

  render() {
    const { item } = this.props;

    const children = item.subMenuItems;
    const title = item.label;
    const url = item.hashUrl;

    if (children && children.length > 0) {
      return (
        <NavDropdown
          id={`first-menu-item-${this._id}`}
          title={title}
          noCaret
        >
          {children.map((subItem, index) => (
            <SecondLevelMenuItem key={index} item={subItem} />
          ))}
        </NavDropdown>
      );
    }

    return <MenuItem href={url} title={title} />;
  }
}

FirstLevelMenuItem.propTypes = {
  item: PropTypes.object.isRequired,
};

export default FirstLevelMenuItem;
