import React from 'react';
import PropTypes from 'prop-types';
import { LinkContainer } from 'react-router-bootstrap';

import NavItem from 'react-bootstrap/es/NavItem';

import UserLinksBasic from '../../../utils/UserLinksBasic';

const MenuItem = ({ href, title }) => {
  const newHref = UserLinksBasic.fixOldAdminUrl(href);

  if (href.startsWith('/')) {
    return (
      <LinkContainer to={newHref}>
        <NavItem>
          {title}
        </NavItem>
      </LinkContainer>
    );
  }

  return <NavItem href={newHref}>{title}</NavItem>;
};

MenuItem.propTypes = {
  href: PropTypes.string.isRequired,
  title: PropTypes.string.isRequired,
};

export default MenuItem;
