/* eslint-disable react/no-array-index-key */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import Nav from 'react-bootstrap/es/Nav';
import FirstLevelMenuItem from './FirstLevelMenuItem';

class ProjectMenu extends PureComponent {
  static lastId = 0;

  render() {
    const { items } = this.props;

    if (!items || items.length === 0) {
      return null;
    }

    return (
      <Nav>
        {items.map((item) => {
          // Hack to fix <LinkContainer> menu items
          ProjectMenu.lastId += 1;
          return <FirstLevelMenuItem key={ProjectMenu.lastId} item={item} />;
        })}
      </Nav>
    );
  }
}

ProjectMenu.propTypes = {
  items: PropTypes.array,
};

ProjectMenu.defaultProps = {
  items: null,
};

export default ProjectMenu;
