/* eslint-disable react/no-array-index-key */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import NavDropdown from 'react-bootstrap/es/NavDropdown';
import MenuItem from './MenuItem';

class SecondLevelMenuItem extends PureComponent {
  static lastId = 0;

  constructor(props) {
    super(props);
    SecondLevelMenuItem.lastId += 1;
    this._id = SecondLevelMenuItem.lastId;
  }

  render() {
    const { item } = this.props;

    const children = item.subMenuItems;
    const title = item.label;
    const url = item.hashUrl;

    if (children && children.length > 0) {
      return (
        <NavDropdown
          id={`second-level-menu-item-${this._id}`}
          className="dropdown-submenu"
          title={title}
          noCaret
        >
          {children.map((subItem, index) => (
            <SecondLevelMenuItem key={index} item={subItem} />
          ))}
        </NavDropdown>
      );
    }

    return <MenuItem href={url} title={title} />;
  }
}

SecondLevelMenuItem.propTypes = {
  item: PropTypes.object.isRequired,
};

export default SecondLevelMenuItem;
