import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { Link } from 'react-router-dom';

class ProjectNav extends PureComponent {
  render() {
    const { projectId, projectName, link } = this.props;
    return (
      <Link to={link} className="solomon-project-nav">
        <div className="solomon-project-nav__name">{projectName}</div>
        <div className="solomon-project-nav__id">{projectId}</div>
      </Link>
    );
  }
}

ProjectNav.propTypes = {
  projectId: PropTypes.string.isRequired,
  projectName: PropTypes.string.isRequired,
  link: PropTypes.oneOfType([PropTypes.string, PropTypes.object]).isRequired,
};

export default ProjectNav;
