import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';

import {
  syncEvents,
  initiateSync,
  signalSyncFailure,
  signalDisconnect,
  markEventsAsSeen,
} from '@yandex-data-ui/infra-buzzer/lib/InfraBuzzer/store/actions';

import { InfraBuzzer, PRODUCTION } from '@yandex-data-ui/infra-buzzer';
import { getEnv } from '../../utils/env';

const { infraOptions } = getEnv();

class SolomonInfraBuzzer extends PureComponent {
  render() {
    if (!infraOptions) {
      return null;
    }

    const { infraBuzzer, ...restOptions } = this.props;

    return (
      <InfraBuzzer
        subscribeTo={infraOptions}
        environment={PRODUCTION}
        {...infraBuzzer}
        {...restOptions}
      />
    );
  }
}

SolomonInfraBuzzer.propTypes = {
  infraBuzzer: PropTypes.object.isRequired,
};

function mapStateToProps(state) {
  return { infraBuzzer: state.infraBuzzer };
}

const mapDispatchToProps = {
  syncEvents,
  initiateSync,
  signalSyncFailure,
  signalDisconnect,
  markEventsAsSeen,
};

export default connect(mapStateToProps, mapDispatchToProps)(SolomonInfraBuzzer);
