import React from 'react';
import PropTypes from 'prop-types';
import Highcharts from 'highcharts/highcharts';

import HighchartsReact from 'highcharts-react-official';

const HighchartsChart = ({ options }) => (
  /* Necessary wrapper to fix tooltip display */
  <div className="highcharts-chart" style={{ position: 'relative' }}>
    <HighchartsReact
      highcharts={Highcharts}
      options={options}
    />
  </div>
);

HighchartsChart.propTypes = {
  options: PropTypes.object.isRequired,
};

export default HighchartsChart;
