import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import { hostStyle, shortHostname } from '../../utils/hosts';

import './style.css';

class HostLabel extends PureComponent {
  onRefresh = (event) => {
    event.preventDefault();
    this.props.onRefresh(this.props.host);
  };

  render() {
    const shortHost = shortHostname(this.props.host);
    const labelStyle = `label label-${hostStyle(shortHost)} label-host`;
    return (
      <span className={labelStyle}>
        {shortHost}
        <span role="button" tabIndex="-1" onClick={this.onRefresh} className="refresh">
          <i className="glyphicon glyphicon-refresh glyphicon-white" />
        </span>
      </span>
    );
  }
}

HostLabel.propTypes = {
  host: PropTypes.string.isRequired,
  onRefresh: PropTypes.func.isRequired,
};

export default HostLabel;
