import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

class InternalOrExternalLink extends PureComponent {
  render() {
    const { href, target, children } = this.props;
    // TODO (rorewillo@): return local links back after some changes
    return <a target={target} href={href}>{children}</a>;
  }
}

InternalOrExternalLink.propTypes = {
  href: PropTypes.string.isRequired,
  target: PropTypes.string,
  children: PropTypes.oneOfType([PropTypes.string, PropTypes.element]).isRequired,
};

InternalOrExternalLink.defaultProps = {
  target: '',
};

export default InternalOrExternalLink;
