/* eslint-disable no-bitwise */
const MAX_KEY_LEN = 32;
const MAX_VALUE_LEN = 200;

function isAscii(c) {
  return (c.charCodeAt(0) & 0xff80) === 0;
}

class LabelValidator {
  static validateKey(key) {
    try {
      if (!key) {
        return 'label key is empty';
      }

      if (key.length > MAX_KEY_LEN) {
        return `length is greater than ${MAX_KEY_LEN}`;
      }

      const firstCh = key[0];
      if (!isAscii(firstCh)) {
        return `character "${firstCh}" is not ASCII`;
      }
      if (!((firstCh >= 'a' && firstCh <= 'z') || (firstCh >= 'A' && firstCh <= 'Z'))) {
        return `first character "${firstCh}" is not permitted, expected latin letter: [a-ZA-Z]`;
      }

      for (let pos = 0; pos < key.length; ++pos) {
        const ch = key[pos];
        if (!isAscii(ch)) {
          return `character "${ch}" is not ASCII`;
        }
        if (!((ch >= 'a' && ch <= 'z') || (ch >= 'A' && ch <= 'Z') || (ch >= '0' && ch <= '9') || ch === '_')) {
          return `character "${ch}" at position ${pos + 1} is not permitted, expected latin letter, digit or underscore: [a-zA-Z0-9_]`;
        }
      }
      return null;
    } catch (e) {
      console.error(`failed to validate label key: ${key}`, e);
      return null;
    }
  }

  static validateValue(value) {
    try {
      if (!value) {
        return 'label value is empty';
      }

      if (value === '-') {
        return '"-" is forbidden label value';
      }

      if (value.length > MAX_VALUE_LEN) {
        return `value length is greater than ${MAX_VALUE_LEN}`;
      }

      for (let pos = 0; pos < value.length; ++pos) {
        const ch = value[pos];
        if (!(ch >= ' ' && ch <= '~')) {
          return `character "${ch}" at position ${pos + 1} is not printable ASCII`;
        }
        if (ch === '*' || ch === '?' || ch === '"' || ch === '\'' || ch === '`' || ch === '\\') {
          return `character "${ch}" at position ${pos + 1} is not permitted, because it's special symbol`;
        }
      }
      return null;
    } catch (e) {
      console.error(`failed to validate label value: ${value}`, e);
      return null;
    }
  }
}

export default LabelValidator;
