import React from 'react';
import PropTypes from 'prop-types';

import './style.css';

const LabeledValue = ({
  label, value, hint, labelWidth,
}) => {
  let valueView = value;
  if (typeof value === 'boolean') {
    valueView = value ? 'yes' : 'no';
  }
  let canWordBreak = false;
  if (typeof value === 'string') {
    canWordBreak = true;
  }

  return (
    <div className="row labeled-value">
      <div className={`col-xs-${labelWidth}`}>
        <b>{label}</b>
&nbsp;
      </div>
      <div className={`col-xs-${12 - labelWidth}${canWordBreak ? ' word-break' : ''}`}>
        {valueView}
        {hint && (
          <>
            &nbsp;
            <span className="hint-block">
              (
              {hint}
              )
            </span>
          </>
        )}
      </div>
    </div>
  );
};

LabeledValue.propTypes = {
  label: PropTypes.string,
  value: PropTypes.oneOfType([
    PropTypes.string,
    PropTypes.number,
    PropTypes.bool,
    PropTypes.element,
    PropTypes.func,
  ]),
  hint: PropTypes.string,
  labelWidth: PropTypes.number,
};

LabeledValue.defaultProps = {
  label: '',
  value: '',
  hint: '',
  labelWidth: 3,
};

export default LabeledValue;
