import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import TableEditor from '../TableEditor';

import { ReadonlyRow, EditableRow } from './LabelsTable';

import { deleteItemReducer, updateItemReducer } from '../../utils/items';

class LabelsEditor extends PureComponent {
  onDelete = (index) => {
    const values = deleteItemReducer(this.props.values, index);
    this.props.onChange(values);
  };

  onUpdate = (index, item) => {
    const values = updateItemReducer(this.props.values, index, item);
    this.props.onChange(values);
  };

  render() {
    const { values, readOnly, additional } = this.props;

    return (
      <TableEditor
        columns={['']}
        values={values}
        readonlyRow={ReadonlyRow}
        editableRow={EditableRow}
        onDelete={this.onDelete}
        onUpdate={this.onUpdate}
        readOnly={readOnly}
        additional={additional}
      />
    );
  }
}

LabelsEditor.propTypes = {
  values: PropTypes.arrayOf(PropTypes.string),
  onChange: PropTypes.func.isRequired,
  readOnly: PropTypes.bool,
  additional: PropTypes.object,
};

LabelsEditor.defaultProps = {
  values: [],
  readOnly: false,
  additional: {},
};

export default LabelsEditor;
