/* eslint-disable max-classes-per-file */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import wrapHandler from '../../utils/handlerWrapper';

export class ReadonlyRow extends PureComponent {
  constructor(props) {
    super(props);
    this.onClick = wrapHandler(props.index, props.onClick);
    this.onDelete = wrapHandler(props.index, props.onDelete);
  }

  render() {
    const { value, noBadge } = this.props;
    return (
      <tr onClick={this.props.readOnly ? undefined : this.onClick}>
        <td>
          {noBadge ? value : <span className="label label-default">{value}</span>}
        </td>
        {!this.props.readOnly && this.onDelete ? (
          <td className="actions">
            <button type="button" onClick={this.onDelete}>
              <i className="glyphicon glyphicon-remove" />
            </button>
          </td>
        ) : <td />}
      </tr>
    );
  }
}

ReadonlyRow.propTypes = {
  index: PropTypes.number.isRequired,
  value: PropTypes.string.isRequired,
  onClick: PropTypes.func,
  onDelete: PropTypes.func,
  readOnly: PropTypes.bool,
  noBadge: PropTypes.bool,
};

ReadonlyRow.defaultProps = {
  onClick: null,
  onDelete: null,
  readOnly: false,
  noBadge: false,
};

export class EditableRow extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { value: this.props.value };
  }

  componentDidMount() {
    this.inputEl.focus();
  }

  onOkClick = (event) => {
    event.preventDefault();
    event.stopPropagation();
    this.doComplete();
  };

  onKeyDown = (event) => {
    if (event.which === 13) {
      event.preventDefault();
      event.stopPropagation();
      this.doComplete();
    } else if (event.which === 27) {
      event.preventDefault();
      this.props.onCancel();
    }
  };

  onInputChange = (event) => {
    this.setState({ value: event.target.value });
  };

  doComplete() {
    const { onOk, index } = this.props;
    onOk(index, this.state.value);
  }

  render() {
    const { value } = this.state;
    return (
      <tr onKeyDown={this.onKeyDown}>
        <td>
          <input
            type="text" name="value" className="form-control"
            value={value} onChange={this.onInputChange}
            ref={(input) => { this.inputEl = input; }}
          />
        </td>
        <td className="actions">
          <button type="button" onClick={this.onOkClick}>
            <i className="glyphicon glyphicon-ok" />
          </button>
        </td>
      </tr>
    );
  }
}

EditableRow.propTypes = {
  index: PropTypes.number.isRequired,
  value: PropTypes.string,
  onOk: PropTypes.func.isRequired,
  onCancel: PropTypes.func.isRequired,
};

EditableRow.defaultProps = {
  value: '',
};
