import React from 'react';
import PropTypes from 'prop-types';

import './style.css';

const LabelsList = ({ values, type }) => (
  <ul className="labels-list">
    {values.map((v, i) => (
      /* eslint-disable react/no-array-index-key */
      <li key={i}>
        <span className={`label label-${type}`}>{v}</span>
      </li>
      /* eslint-enable */
    ))}
  </ul>
);

LabelsList.propTypes = {
  values: PropTypes.arrayOf(PropTypes.string).isRequired,
  type: PropTypes.oneOf([
    'default',
    'primary',
    'success',
    'info',
    'warning',
    'danger',
  ]),
};

LabelsList.defaultProps = {
  type: 'default',
};

export default LabelsList;
