import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import './style.css';

class LoadMore extends PureComponent {
  handleClick = (event) => {
    event.preventDefault();
    this.props.onLoadMore();
  };

  render() {
    return (
      <div className="row load_more">
        <div className="text-center">
          <button
            type="button"
            className="btn btn-default"
            onClick={this.handleClick}
            ref={(btn) => { this._btn = btn; }}
          >
            Load more...
          </button>
        </div>
      </div>
    );
  }
}

LoadMore.propTypes = {
  onLoadMore: PropTypes.func.isRequired,
};

export default LoadMore;
