import React from 'react';
import PropTypes from 'prop-types';
import { formatLocalDate } from '../utils/localDate';

export const MIN_DATE = new Date(2010);

const LocalDate = ({ date }) => {
  let localDate;

  if (date) {
    try {
      const parsedDate = new Date(date);
      if (parsedDate < MIN_DATE) {
        localDate = 'Never';
      } else {
        localDate = formatLocalDate(parsedDate);
      }
    } catch (e) {
      localDate = date;
    }
  } else {
    localDate = '';
  }

  return (
    <span className="local-date">
      {localDate}
    </span>
  );
};

LocalDate.propTypes = {
  date: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
};

LocalDate.defaultProps = {
  date: '',
};

export default LocalDate;
