/* eslint-disable react/no-danger */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { escapeHtml } from 'markdown-it/lib/common/utils';

import LinkifyIt from 'linkify-it';

import './style.css';

const linkifyIt = new LinkifyIt();

function linkify(text) {
  const matches = linkifyIt.match(text);
  const result = [];

  let last;

  if (matches) {
    last = 0;
    matches.forEach((match) => {
      if (last < match.index) {
        result.push(escapeHtml(text.slice(last, match.index)));
      }

      const aHtml = `<a target="_blank" href="${escapeHtml(match.url)}">${escapeHtml(match.text)}</a>`;
      result.push(aHtml);
      last = match.lastIndex;
    });
    if (last < text.length) {
      result.push(escapeHtml(text.slice(last)));
    }
    return result.join('');
  }

  return escapeHtml(text);
}

class Linkifier extends PureComponent {
  render() {
    const html = linkify(this.props.text);

    return (
      <div className="solomon-markdown" dangerouslySetInnerHTML={{ __html: html }} />
    );
  }
}

Linkifier.propTypes = {
  text: PropTypes.string.isRequired,
};

export default Linkifier;
