/* eslint-disable react/no-danger */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import markdownit from 'markdown-it';

import './style.css';

class Markdown extends PureComponent {
  render() {
    let html = '';
    try {
      const md = markdownit({ linkify: true });
      html = md.render(this.props.text);
    } catch (e) {
      html = '';
    }

    html = html.replace(/<table>/g, '<table class="table table-striped table-bordered">');

    return (
      <div className="solomon-markdown" dangerouslySetInnerHTML={{ __html: html }} />
    );
  }
}

Markdown.propTypes = {
  text: PropTypes.string.isRequired,
};

export default Markdown;
