import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import './style.css';

class MenuEditableNode extends PureComponent {
  constructor(props) {
    super(props);

    this.state = props.data;
  }

  componentDidMount() {
    this.titleInput.focus();
  }

  onInputChange = (event) => {
    const { target } = event;
    this.setState({ [target.name]: target.value });
  };

  onSubmitClick = (event) => {
    event.preventDefault();
    this.doComplete();
  };

  onDiscardClick = (event) => {
    event.preventDefault();
    if (this.props.onDiscard) {
      this.props.onDiscard();
    }
  };

  onKeyDown = (event) => {
    if (event.which === 13) {
      event.preventDefault();
      this.doComplete();
    } else if (event.which === 27) {
      event.preventDefault();
      this.props.onDiscard();
    }
  };

  doComplete() {
    const newNode = { ...this.state };
    if (!newNode.title) {
      return;
    }
    this.props.onSubmit(this.props.path, newNode);
  }

  render() {
    const { data } = this.props;
    const { title = '', url = '', selectors = '' } = this.state;

    // eslint-disable-next-line no-mixed-operators
    const isTree = data.children && data.children.length > 0;

    return (
      <div
        tabIndex={-1}
        role="link"
        className="menu-editor-node menu-editor-node_editable menu-editor-node_active"
        onKeyDown={this.onKeyDown}
      >
        <div className="menu-editor-node__toggler" />
        <div className="menu-editor-node__content">
          <div className="menu-editor-node__title">
            <input
              type="text"
              name="title" placeholder="Title..."
              value={title}
              onChange={this.onInputChange}
              ref={(input) => { this.titleInput = input; }}
            />
          </div>
          {!isTree && (
            <div className="menu-editor-node__url">
              <input
                type="text"
                name="url" placeholder="Url..."
                value={url}
                onChange={this.onInputChange}
              />
            </div>
          )}
          <div className="menu-editor-node__selectors">
            <input
              type="text"
              name="selectors" placeholder="Selectors..."
              value={selectors}
              onChange={this.onInputChange}
            />
          </div>
        </div>
        <div className="menu-editor-node__buttons">
          <i className="glyphicon glyphicon-ok" role="link" tabIndex={-1} onClick={this.onSubmitClick} />
          <i className="glyphicon glyphicon-remove" role="link" tabIndex={-1} onClick={this.onDiscardClick} />
        </div>
      </div>
    );
  }
}

MenuEditableNode.propTypes = {
  path: PropTypes.array.isRequired,
  data: PropTypes.object,
  onSubmit: PropTypes.func.isRequired,
  onDiscard: PropTypes.func.isRequired,
};

MenuEditableNode.defaultProps = {
  data: { title: '', url: '', selectors: '' },
};

export default MenuEditableNode;
