import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import isEqual from 'lodash/isEqual';

import MenuEditableNode from './MenuEditableNode';

function makeEditPath(parentPath) {
  return parentPath ? [...parentPath, -1] : [-1];
}

class NewNodePanel extends PureComponent {
  onNewNodeClick = (event) => {
    event.preventDefault();
    this.props.onEdit(makeEditPath(this.props.parentPath));
  };

  onSubmitNewNode = (path, node) => {
    this.props.onAppendChild(this.props.parentPath, node);
  };

  render() {
    const { isSmall, parentPath, editPath } = this.props;
    const nodePath = makeEditPath(parentPath);

    let inner;

    if (isEqual(editPath, nodePath)) {
      inner = (
        <MenuEditableNode
          path={nodePath}
          onSubmit={this.onSubmitNewNode}
          onDiscard={this.props.onDiscard}
        />
      );
    } else {
      inner = (
        <button
          type="button"
          className={`btn btn-default${isSmall ? ' btn-sm' : ''}`}
          onClick={this.onNewNodeClick}
        >
          <i className="glyphicon glyphicon-plus" />
        </button>
      );
    }

    return (
      <li className="menu-editor-tree">
        {inner}
      </li>
    );
  }
}

NewNodePanel.propTypes = {
  isSmall: PropTypes.bool,
  editPath: PropTypes.arrayOf(PropTypes.number).isRequired,
  parentPath: PropTypes.arrayOf(PropTypes.number),
  onEdit: PropTypes.func.isRequired,
  onAppendChild: PropTypes.func.isRequired,
  onDiscard: PropTypes.func.isRequired,
};

NewNodePanel.defaultProps = {
  isSmall: false,
  parentPath: null,
};

export default NewNodePanel;
