import React from 'react';
import PropTypes from 'prop-types';
import ReactModal from 'react-modal';

import './style.css';

if (process.env.NODE_ENV !== 'test') {
  ReactModal.setAppElement('#root');
}

const Modal = ({
  title, isOpen, onOk, onCancel, okTitle, cancelTitle, large, children,
}) => (
  <ReactModal
    className="modal-dialog"
    contentLabel="Modal"
    isOpen={isOpen}
    onRequestClose={onCancel}
  >
    <div className={`modal-content${large ? ' modal-lg' : ''}`}>
      <div className="modal-header">
        <button type="button" className="close" onClick={onCancel}>
          <span aria-hidden="true">&times;</span>
        </button>
        <h4 className="modal-title">{title}</h4>
      </div>
      <div className="modal-body">
        {children}
      </div>
      <div className="modal-footer">
        {onOk && (
          <button type="button" className="btn btn-outline btn-primary" onClick={onOk}>
            {okTitle}
          </button>
        )}
        <button type="button" className="btn btn-outline btn-default" onClick={onCancel}>
          {cancelTitle}
        </button>
      </div>
    </div>
  </ReactModal>
);

Modal.propTypes = {
  title: PropTypes.string.isRequired,
  isOpen: PropTypes.bool.isRequired,
  onOk: PropTypes.func,
  onCancel: PropTypes.func.isRequired,
  okTitle: PropTypes.string,
  cancelTitle: PropTypes.string,
  large: PropTypes.bool,
  children: PropTypes.node.isRequired,
};

Modal.defaultProps = {
  onOk: null,
  okTitle: 'Ok',
  cancelTitle: 'Cancel',
  large: false,
};

export default Modal;
