/* eslint-disable operator-linebreak */
/* eslint-disable max-len */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import { disableNewUiAlert } from '../store/reducers/others/userSettings';
import { isPreOrProdIntEnv } from '../utils/env';
import { getMonitoringUiHost } from '../pages/old/utils/graphToExpressionTransformations';

class NewUiAlert extends PureComponent {
  onClose = (event) => {
    event.preventDefault();
    this.props.disableNewUiAlert();
  };

  render() {
    if (!isPreOrProdIntEnv()) {
      return null;
    }

    const {
      type, projectId, dashId, url, show,
    } = this.props;

    let finalUrl;
    let finalStyle = 'alert alert-warning';
    let forDescription;

    if (type === 'adminAutoGraph') {
      finalUrl =
        url ||
        `https://${getMonitoringUiHost()}/projects/${projectId}/explorer`;
      forDescription = 'for working with functions!';
    } else if (type === 'adminDashboard') {
      finalUrl = `https://${getMonitoringUiHost()}/projects/${projectId}/dashboards/${dashId ? `${dashId}/edit` : 'new'}`;
      forDescription = `preview for ${dashId ? 'editing' : 'creating'} dashboards!`;
    } else {
      finalUrl = url;
      finalStyle = 'alert alert-info';
      if (type === 'autoGraph') {
        forDescription = 'for working with functions instead of classic auto graph!';
      } else if (type === 'graph') {
        forDescription = 'for viewing dashboards instead of classic configured graphs!';
      } else if (type === 'dashboard') {
        forDescription = 'for viewing new dashboards!';
      } else {
        return null;
      }
    }

    if (finalUrl && show) {
      return (
        <div className={finalStyle}>
          <button type="button" className="close" onClick={this.onClose}>&times;</button>
          Try out
          {' '}
          <a href={finalUrl} style={{ textDecoration: 'underline' }}><b>Monitoring UI</b></a>
          {' '}
          {forDescription}
          {' '}
          It offers a simpler and easier to use interface for this task. More information about preview is available
          {' '}
          <a href="https://wiki.yandex-team.ru/solomon/projects/themonitoring/work/ui/preview/">here</a>
          .
        </div>
      );
    }

    return null;
  }
}

NewUiAlert.propTypes = {
  type: PropTypes.string.isRequired,
  projectId: PropTypes.string,
  dashId: PropTypes.string,
  url: PropTypes.string,
  show: PropTypes.bool.isRequired,
  disableNewUiAlert: PropTypes.func.isRequired,
};

NewUiAlert.defaultProps = {
  projectId: '',
  dashId: '',
  url: '',
};

const mapStateToProps = (state) => ({
  show: state.userSettings.data
    && state.userSettings.data.settings.experimentalShowNewUiAlert !== 'false',
});

const mapDispatchToProps = (dispatch) => bindActionCreators({
  disableNewUiAlert,
}, dispatch);

export default connect(mapStateToProps, mapDispatchToProps)(NewUiAlert);
