import React from 'react';
import PropTypes from 'prop-types';
import { PAGE_TITLE } from '../../utils/titles';

const PageTitle = ({ title, subTitle }) => {
  document.title = title ? `${title} — ${PAGE_TITLE}` : PAGE_TITLE;

  let titleEl;

  if (subTitle) {
    titleEl = (
      <h3>
        {title}
        &nbsp;
        <small>{subTitle}</small>
      </h3>
    );
  } else {
    titleEl = (<h3>{title}</h3>);
  }

  return (
    <div className="row">
      {titleEl}
      <hr />
    </div>
  );
};

PageTitle.propTypes = {
  title: PropTypes.string.isRequired,
  subTitle: PropTypes.oneOfType([PropTypes.element, PropTypes.string]),
};

PageTitle.defaultProps = {
  subTitle: null,
};

export default PageTitle;
