import React from 'react';
import PropTypes from 'prop-types';
import PaginationButton from './PaginationButton';

const MAX_PAGE_SIZE = 10000;
const DEFAULT_PAGE_SIZES = [10, 30, 50];

const PageSizer = ({
  pageSize, totalCount, hideTotalCount, onPageSizeChange,
}) => {
  const pageSizeOptions = DEFAULT_PAGE_SIZES.slice();
  if (pageSize >= 0) {
    if (pageSizeOptions.indexOf(pageSize) < 0) {
      pageSizeOptions.push(pageSize);
      pageSizeOptions.sort();
    }
  }

  const pageSizeButtons = pageSizeOptions
    .filter((size) => totalCount >= 0 && size < totalCount)
    .map((size) => (
      <PaginationButton
        key={size}
        active={size === pageSize}
        onClick={() => onPageSizeChange(size)}
      >
        {size}
      </PaginationButton>
    ));

  const totalButtonTitle = hideTotalCount ? 'All' : `All (${totalCount})`;

  pageSizeButtons.push((
    <PaginationButton
      key="all"
      active={pageSize < 0}
      disabled={totalCount > MAX_PAGE_SIZE}
      onClick={() => onPageSizeChange('all')}
    >
      {totalButtonTitle}
    </PaginationButton>
  ));

  return (
    <div className="pagination">
      {pageSizeButtons}
    </div>
  );
};

PageSizer.propTypes = {
  pageSize: PropTypes.number.isRequired,
  totalCount: PropTypes.number.isRequired,
  hideTotalCount: PropTypes.bool.isRequired,
  onPageSizeChange: PropTypes.func.isRequired,
};

export default PageSizer;
