import React from 'react';
import PropTypes from 'prop-types';
import SimplePagination from './SinglePagination';
import PageSizer from './PageSizer';

const Pagination = ({
  activePage, pageCount,
  pageSize, totalCount,
  onActivePageChange, onPageSizeChange,
  hidePagination, hideTotalCount,
}) => {
  if (pageSize >= totalCount) {
    return null;
  }

  return (
    <div>
      <div className="pull-left">
        {!hidePagination && (
          <SimplePagination
            activePage={activePage}
            pageCount={pageCount}
            onActivePageChange={onActivePageChange}
          />
        )}
      </div>
      <div className="pull-right">
        <PageSizer
          pageSize={pageSize}
          totalCount={totalCount}
          hideTotalCount={hideTotalCount}
          onPageSizeChange={onPageSizeChange}
        />
      </div>
    </div>
  );
};

Pagination.propTypes = {
  activePage: PropTypes.number.isRequired,
  pageCount: PropTypes.number.isRequired,
  pageSize: PropTypes.number.isRequired,
  totalCount: PropTypes.number.isRequired,
  onActivePageChange: PropTypes.func.isRequired,
  onPageSizeChange: PropTypes.func.isRequired,
  hidePagination: PropTypes.bool,
  hideTotalCount: PropTypes.bool,
};

Pagination.defaultProps = {
  hidePagination: false,
  hideTotalCount: false,
};

export default Pagination;
