import PropTypes from 'prop-types';
import React from 'react';

const PaginationButton = ({
  active, disabled, onClick, children,
}) => {
  const onPaginationClick = (event) => {
    event.preventDefault();
    if (!disabled && onClick) {
      onClick();
    }
  };
  return (
    <li className={`page-item${disabled ? ' disabled' : ''}${active ? ' active' : ''}`}>
      <a className="page-link" href="#" onClick={onPaginationClick}>
        {children}
      </a>
      {/* eslint-enable */}
    </li>
  );
};

PaginationButton.propTypes = {
  active: PropTypes.bool,
  disabled: PropTypes.bool,
  onClick: PropTypes.func,
  children: PropTypes.node.isRequired,
};

PaginationButton.defaultProps = {
  active: false,
  disabled: false,
  onClick: () => {},
};

export default PaginationButton;
